﻿<%@ Import Namespace="Soneta.Kadry" %>
<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Page language="c#" AutoEventWireup="false" codePage="1200" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<title>Historia zatrudnienia</title>
		<script runat="server">
	
	void OnContextLoad(Object sender, EventArgs args) {
        ArrayList lista = new ArrayList();

        Row[] rows = (Row[])dc[typeof(Row[])];
        foreach (Pracownik pp in rows)
            foreach (HistoriaZatrudnieniaBase hzb in pp.HistoriaZatrudnienia) {
                if (hzb.Typ == TypHistoriiZatrudnienia.Wyksztalcenie)
                    continue;
                HistoriaZatrudnienia hz = (HistoriaZatrudnienia)hzb;
                if (hz == null)
                    continue;
                lista.Add(hz);
            }

        Grid1.DataSource = lista;
	}

    protected void Grid1_BeforeRow(object sender, RowEventArgs args) {
        HistoriaZatrudnienia hz = (HistoriaZatrudnienia)args.Row;

        col1.EditValue = hz.Nazwa;
        col2.EditValue = hz.Adres1 + " " + hz.Adres2;
        col3.EditValue = hz.Okres.ToString();
        col4.EditValue = hz.Stanowisko;
        col5.EditValue = hz.KodWykonywanegoZawodu;
        col6.EditValue = hz.TyUb.ToString();
        col7.EditValue = hz.EfektywnyOkres.ToString();
        foreach (OkresNiewliczany onw in hz.OkresyNiewliczane)
            col8.AddLine(onw.Okres.ToString());
        col9.EditValue = hz.Korekta.ToString();
        col10.EditValue = hz.Staz;
    }		        

		</script>
		
		<meta content="Microsoft Visual Studio 7.0" name="GENERATOR">
		<meta content="C#" name="CODE_LANGUAGE">
		<meta content="JavaScript" name="vs_defaultClientScript">
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
	</HEAD>
	<body>
		<form id="HistoriaZatrudnienia" method="post" runat="server">
			<ea:datacontext id="dc" runat="server" TypeName="Soneta.Business.Row[], Soneta.Business" oncontextload="OnContextLoad" Landscape="True"></ea:datacontext>
			<cc1:ReportHeader NagłówekOddziału="NagłówekOddziału" id="ReportHeader1" runat="server" title="Historia zatrudnienia"></cc1:ReportHeader>
			<ea:Grid id="Grid1" runat="server" onbeforerow="Grid1_BeforeRow" GroupLine="{0}" GroupData0="Pracownik">
				<Columns>
					<ea:GridColumn Width="4" Align="Right" DataMember="#" Caption="Lp."></ea:GridColumn>
					<ea:GridColumn ID="col1" Caption="Nazwa"></ea:GridColumn>
					<ea:GridColumn Width="25" ID="col2" Caption="Adres"></ea:GridColumn>
					<ea:GridColumn Width="21" ID="col3" Caption="Okres zatrudnienia"></ea:GridColumn>
					<ea:GridColumn Width="15" ID="col4" Caption="Ostatnio zajmowane stanowisko"></ea:GridColumn>
					<ea:GridColumn Width="8" ID="col5" Caption="Kod wyk. zawodu"></ea:GridColumn>
					<ea:GridColumn Width="8" ID="col6" Caption="Tytuł ubezp."></ea:GridColumn>
					<ea:GridColumn Width="21" ID="col7" Caption="Okres wliczany do stażu pracy"></ea:GridColumn>
					<ea:GridColumn Width="21" ID="col8" Caption="Okres niewliczany do stażu pracy"></ea:GridColumn>
					<ea:GridColumn Width="10" ID="col9" Caption="Korekta (url.bezpł., wych. …)"></ea:GridColumn>
					<ea:GridColumn Width="10" ID="col10" Caption="Staż pracy (lata, mies., dni)"></ea:GridColumn>
				</Columns>
			</ea:Grid>
			<cc1:ReportFooter id="ReportFooter1" runat="server" TheEnd="False"></cc1:ReportFooter>
		</form>
	</body>
</HTML>

